﻿#include <iostream>
#include <vector>
#include <numeric>
#include <algorithm>
#include <stack>
#include <queue>
#include <set>
#include <unordered_set>
#include <map>
#include <unordered_map>
#include <cassert>
#include <bitset>
#include <cmath>
#include <string>

#pragma GCC optimize("O3,unroll-loops")
// #pragma GCC target("avx2,bmi,bmi2,lzcnt,popcnt")

using namespace std;

using ll = long long;
using ld = long double;

const int INT_INF = 2e9 + 10;
const ll LL_INF = 2e18 + 10;

const int MOD = 1e9 + 7;

template<typename T> istream& operator >> (istream& in, vector<T>& a) {
	for (auto& i : a) {
		in >> i;
	}
	return in;
}

vector<int> get_divs(int n) {
	vector<int> pref, suff;
	int i = 1;
	for (; i * i < n; i++) {
		if (n % i == 0) {
			pref.push_back(i);
			suff.push_back(n / i);
		}
	}
	if (i * i == n) {
		pref.push_back(i);
	}
	for (int j = suff.size() - 1; j >= 0; j--) {
		pref.push_back(suff[j]);
	}
	return pref;
}

int main() {
	int t;
	cin >> t;
	while (t--) {
		int x, y;
		cin >> x >> y;
		int c = y - x;
		if (c == 0) {
			cout << 0 << '\n';
			continue;
		}
		vector<int> divs = get_divs(c);
		reverse(divs.begin(), divs.end());
		int ans;
		for (auto d : divs) {
			if (x >= d) {
				ans = x - d;
				break;
			}
		}
		cout << ans << '\n';
	}
}
